<?php
/**********************************************************************************************************/
/*******           LECTURE DES FICHIERS DE LANGUE                                               ***********/
/**********************************************************************************************************/

include "language.defines.php";

if (!AUTO_MODE)
{
  if ($lang_select=="auto")
  {
    $lang_select = "";
  }
}

if (file_exists($_LANG_DIR))
{
  $dispo_lang = GetDispoLang();
}

if ( AUTO_MODE && 
    ( $lang_select=="auto" ||
      ($LANG_COOKIE=="auto" && $lang_select=="") ||
      (!$lang_select && !$LANG_COOKIE) )
   )
{
  $dl = new detect_language;
  $_DETECTED_LANG = $_SELECT_LANG = $dl->detected_language;
  
  if (is_array($dispo_lang) && !in_array($_SELECT_LANG, $dispo_lang))
  {
    $_SELECT_LANG = $_DEFAULT_LANG;
  }
  
  $LANG_COOKIE = "auto";
  setcookie("LANG_COOKIE", "auto");
}
else
if ($lang_select!="")
{
  $_SELECT_LANG = $lang_select;
  $LANG_COOKIE  = $_SELECT_LANG;
  setcookie("LANG_COOKIE", $_SELECT_LANG);
}
else
{
  $_SELECT_LANG=$LANG_COOKIE;
}

/**
 **************************************************************************************************************************************************************
 * function GetLang()
 **************************************************************************************************************************************************************
 * @file    language.class.php
 * @author  Grald Fauvelle
 * @date    07/06/2003
 * @param   none
 * @comment Renvoie le language dtect, voulu par le visiteur (par slection ou cookie)
 **************************************************************************************************************************************************************/
function GetLang()
{
  global $_SELECT_LANG;
  return $_SELECT_LANG;
}

/**
 **************************************************************************************************************************************************************
 * function GetLang()
 **************************************************************************************************************************************************************
 * @file    language.class.php
 * @author  Grald Fauvelle
 * @date    07/06/2003
 * @param   none
 * @comment Renvoie le language dtect, voulu par le visiteur (par slection ou cookie)
 **************************************************************************************************************************************************************/
function GetDetectedLang()
{
  $dl = new detect_language;
  return $dl->detected_language;
}


/**
 **************************************************************************************************************************************************************
 * function GetDispoLang()
 **************************************************************************************************************************************************************
 * @file    language.class.php
 * @author  Grald Fauvelle
 * @date    07/06/2003
 * @param   none
 * @comment On ouvre le fichier de langues, on le parcourt, et on rcupre les fichiers qui sont dedans, 
 *          on les met dans un tableau                                                                           
 **************************************************************************************************************************************************************/
function GetDispoLang()
{
  global $_LANG_DIR;
  global $_EXT_LANG;
  
  $dossier=opendir($_LANG_DIR);
  
  if (AUTO_MODE)
  {
    $i=1;
    $aLang[0] = "auto";
  }
  else
  {
    $i=0;
  }
  
  while ($fichier = readdir($dossier))
  {
  	if ( $fichier!='.' && $fichier!='..' )  // pas les rpertoires . et ..
  	{
  		if (is_file($_LANG_DIR."/".$fichier))
  		{
    		$aFile = explode(".", $fichier);
    		$ext   = $aFile[count($aFile)-1];
    		
    		if ($ext == $_EXT_LANG)
        {
          $aLang[$i++] = $aFile[0];
        }
  		}
  	}
  }
  
  return $aLang;
}


/**
 **************************************************************************************************************************************************************
 * function GetDispoLang()
 **************************************************************************************************************************************************************
 * @file    language.class.php
 * @author  Grald Fauvelle
 * @date    07/06/2003
 * @param   none
 * @comment Copyright (c) 2002 Stephane Garin <sgarin@sgarin.com>
 *          Released under the GNU General Public License
 *          Original class: detect_language 0.1 04/02/2002
 *          Modified class: detect_language 0.2 04/20/2002
 *          (contribution of Harald Ponce de Leon)
 *          contributor: Thanks to Harald Ponce de Leon
 *          (osCommerce, Open Source E-Commerce Solutions)
 *          http://www.oscommerce.com
 *          description: A class to detect prefered language
 *          of the Internet browser of the visitor.
 **************************************************************************************************************************************************************/
class detect_language
{
  var $available_languages, $accepted_language, $detected_language;

  // Constructor
  function detect_language()
  {
    $this->available_languages = array
    (
      'bg'         => array('bg|bulgarian', 'bulgarian-win1251'),
      'ca'         => array('ca|catalan', 'catala'),
      'cs-iso'     => array('cs|czech', 'czech-iso'),
      'cs-win1250' => array('cs|czech', 'czech-win1250'),
      'da'         => array('da|danish', 'danish'),
      'de'         => array('de([-_][[:alpha:]]{2})?|german', 'german'),
      'english'    => array('en([-_][[:alpha:]]{2})?|english', 'english'),
      'spanish'    => array('es([-_][[:alpha:]]{2})?|spanish', 'spanish'),
      'french'     => array('fr([-_][[:alpha:]]{2})?|french', 'french'),
      'it'         => array('it|italian', 'italian'),
      'ja'         => array('ja|japanese', 'japanese'),
      'ko'         => array('ko|korean', 'korean'),
      'nl'         => array('nl([-_][[:alpha:]]{2})?|dutch', 'dutch'),
      'no'         => array('no|norwegian', 'norwegian'),
      'pl'         => array('pl|polish', 'polish'),
      'pt-br'      => array('pt[-_]br|brazilian portuguese', 'brazilian_portuguese'),
      'pt'         => array('pt([-_][[:alpha:]]{2})?|portuguese', 'portuguese'),
      'ru-koi8r'   => array('ru|russian', 'russian-koi8'),
      'ru-win1251' => array('ru|russian', 'russian-win1251'),
      'se'         => array('se|swedish', 'swedish'),
      'sk'         => array('sk|slovak', 'slovak-iso'),
      'th'         => array('th|thai', 'thai'),
      'zh-tw'      => array('zh[-_]tw|chinese traditional', 'chinese_big5'),
      'chinese'    => array('zh|chinese simplified', 'chinese_gb')
    );
    $this->accepted_language = explode(',', getenv('HTTP_ACCEPT_LANGUAGE'));
    $this->detected_language = $this->getLanguage();
  }

/*
  getLanguage
  -----------
  function that look for prefered language by browser.
  Input: -
  Output: language detected or default language (en).
*/
  function getLanguage()
  {
    if (empty($this->detected_language))
    {
      $this->detected_language = 'en';
      $cnt = 0;
      while ($cnt < sizeof($this->accepted_language))
      {
        reset($this->available_languages);
        while (list($key, $value) = each($this->available_languages))
        {
          if ((eregi('^(' . $value[0] . ')(;q=[0-9]\\.[0-9])?$', $this->accepted_language[$cnt])))
          {
            $this->detected_language = $key;
            break 2;
          }
        }
        $cnt++;
      }
    }
    return $this->detected_language;
  }
}
?>